//
//  PriorityBadge.swift
//  Do It Mac
//
//  Created by Jim Dovey on 4/13/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

struct PriorityBadge: View {
    var priority: TodoItem.Priority
    
    var body: some View {
        Text(priority.localizedName)
            .font(.system(.caption, design: .rounded))
            .fontWeight(.semibold)
            .foregroundColor(.white)
            .padding(.horizontal).padding(.vertical, 2)
            .background(priorityColor)
            .clipShape(RoundedRectangle(cornerRadius: 4))
    }
    
    private var priorityColor: Color {
        switch priority {
        case .low: return .gray
        case .normal: return .green
        case .high: return .orange
        case .urgent: return .red
        }
    }
}

struct PriorityBadge_Previews: PreviewProvider {
    static var previews: some View {
        ForEach(ContentSizeCategory.allCases, id: \.self) { contentSize in
            VStack {
                ForEach(TodoItem.Priority.allCases, id: \.self) { priority in
                    Group {
                        PriorityBadge(priority: priority)
                            .padding(2)
                    }
                    .previewLayout(.sizeThatFits)
                }
            }
            .environment(\.sizeCategory, contentSize)
            .previewLayout(.sizeThatFits)
            .previewDisplayName(String(describing: contentSize))
        }
    }
}
